// ---------------------------------------------------------------------------
//	OPM-like Sound Generator
//	Copyright (C) cisc 1998, 2001.
// ---------------------------------------------------------------------------
//	$Id: opm.h,v 1.7 2001/04/15 02:46:10 cisc Exp $

#ifndef FM_OPM_H
#define FM_OPM_H

#include "fmgen.h"
#include "fmtimer.h"
#include "fmfilter.h"
#include "psg.h"

// ---------------------------------------------------------------------------
//	class OPM
//	OPM ɗǂ(?)𐶐鉹jbg
//	
//	interface:
//	bool Init(uint clock, uint rate, bool interpolation);
//		D̃NXgpOɂȂ炸ĂłƁD
//
//		clock:	OPM ̃NbNg(Hz)
//
//		rate:	 PCM ̕W{g(Hz)
//
//		inter.:	`⊮[h
//				true ɂƁCFM ͉̍{̃[gōs悤
//				ȂDŏIIɐ PCM  rate Ŏw肳ꂽ[gɂȂ
//				悤`⊮
//				
//		Ԓl	ɐ true
//
//	bool SetRate(uint clock, uint rate, bool interpolation)
//		NbN PCM [gύX
//		 Init ƓlD
//	
//	void Mix(Sample* dest, int nsamples)
//		Stereo PCM f[^ nsamples C dest Ŏn܂z
//		(Z)
//		Edest ɂ sample*2 ̗̈悪Kv
//		Ei[` L, R, L, R... ƂȂD
//		E܂ŉZȂ̂ŁC炩ߔz[NAKv
//		EFM_SAMPLETYPE  short ^̏ꍇNbsOs.
//		E̊֐͉̃^C}[Ƃ͓ƗĂD
//		  Timer  Count  GetNextEvent ő삷KvD
//	
//	void Reset()
//		Zbg()
//
//	void SetReg(uint reg, uint data)
//		̃WX^ reg  data 
//	
//	uint ReadStatus()
//		̃Xe[^XWX^ǂݏo
//		busy tO͏ 0
//	
//	bool Count(uint32 t)
//		̃^C}[ t [10^(-6) b] i߂D
//		̓Ԃɕω(timer I[o[t[)
//		true Ԃ
//
//	uint32 GetNextEvent()
//		̃^C}[̂ǂ炩I[o[t[܂łɕKv
//		[ʕb]Ԃ
//		^C}[~Ăꍇ 0 ԂD
//	
//	void SetVolume(int db)
//		ẻʂ{|ɒ߂DWl 0.
//		Pʂ͖ 1/2 dBCL͈͂̏ 20 (10dB)
//
//	z֐:
//	virtual void Intr(bool irq)
//		IRQ o͂ɕωꍇĂ΂D
//		irq = true:  IRQ v
//		irq = false: IRQ v
//
namespace FM
{
	//	YM2151(OPM) ----------------------------------------------------
	class OPM : public Timer
	{
	public:
		OPM();
		~OPM() {}
		
		bool	Init(uint c, uint r, bool=false);
		bool	SetRate(uint c, uint r, bool);
		void	SetLPFCutoff(uint freq);
		void	Reset();
		
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		
		void 	Mix(Sample* buffer, int nsamples);
		
		void	SetVolume(int db);
		void	SetChannelMask(uint mask);
		
	private:
		virtual void Intr(bool) {}
	
	private:
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		void	SetParameter(uint addr, uint data);
		void	TimerA();
		void	RebuildTimeTable();
		void	MixSub(int activech, ISample**);
		void	MixSubL(int activech, ISample**);
		void	LFO();
		uint	Noise();
		
		int32	ml[4];
		int32	mr[4];
		int32	mixdelta;
		int		mpratio;
		
		int		fmvolume;

		uint	clock;
		uint	rate;
		uint	pcmrate;
		uint	lpfcutoff;

		uint	pmd;
		uint	amd;
		uint	lfocount;
		uint	lfodcount;
		uint	lfowaveform;
		uint	rateratio;
		uint	noise;
		int32	noisecount;
		uint32	noisedelta;
		
		bool	interpolation;
		uint8	lfofreq;
		uint8	status;
		uint8	reg01;

		uint8	kc[8];
		uint8	kf[8];
		uint8	pan[8];

		Channel4 ch[8];
		LPF		lpf;

		static void	BuildLFOTable();
		static int amtable[4][FM_LFOENTS];
		static int pmtable[4][FM_LFOENTS];
	};
}

#endif // FM_OPM_H
